# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit MultiATSM.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
library(ggplot2)
library(MultiATSM)
library(kableExtra)
library(magrittr)


## ----tab-ModFea-H, eval = knitr::is_html_output(), layout = "l-body-outset"----
# ModelLabels <- c("JPS original", "JPS global", "JPS multi", "GVAR single", "GVAR multi",
#                  "JLL original", "JLL No DomUnit", "JLL joint Sigma")
# 
# # Rows
# Tab <- data.frame(matrix(nrow = length(ModelLabels), ncol = 0))
# rownames(Tab) <- ModelLabels
# 
# # Empty columns
# EmptyCol <- c("", "", "", "", "", "", "", "")
# Tab$EmptyCol0 <- EmptyCol
# # P-dynamics + 2 empty spaces
# Tab$PdynIndUnco <- c("x", "", "", "", "", "", "", "")
# Tab$PdynIndCo <- c("", "", "", "", "", "", "", "")
# Tab$PdynJointUnco <- c("", "x", "x", "", "", "", "", "")
# Tab$PdynJointJLL <- c("", "", "", "", "", "x", "x", "x")
# Tab$PdynJointGVAR <- c("", "", "", "x", "x", "", "", "")
# Tab$EmptyCol1 <- EmptyCol
# Tab$EmptyCol2 <- EmptyCol
# # Q-dynamics + 2 empty spaces
# Tab$QdynInd <- c("x", "x", "", "x", "", "", "", "")
# Tab$QdynJoint <- c("", "", "x", "", "x", "x", "x", "x")
# Tab$EmptyCol3 <- EmptyCol
# Tab$EmptyCol4 <- EmptyCol
# # Sigma + 2 empty spaces
# Tab$Ponly <-  c("", "", "", "", "", "x", "x", "")
# Tab$PandQ <- c("x", "x", "x", "x", "x", "", "", "x")
# Tab$EmptyCol5 <- EmptyCol
# Tab$EmptyCol6 <- EmptyCol
# # Dominant Unit
# Tab$DomUnit <- c("", "", "", "", "", "x", "", "x")
# 
# # Adjust column names
# ColNames <- c("","","","","JLL", "GVAR", "", "", "", "", "", "", "","", "", "","")
# colnames(Tab) <- ColNames
# 
# # Generate the table
# kableExtra::kbl(Tab, align = "c", caption = "Summary of model features") %>%
#   kableExtra::kable_classic("striped", full_width = F)  %>%
#   kableExtra::row_spec(0, font_size = 10) %>%
#   kableExtra::add_header_above(c(" "=2, "UR" = 1, "R" = 1, "UR" = 1, "R" = 2, " " = 11)) %>%
#  kableExtra::add_header_above(c(" "=2, "Single" = 2, "Joint" = 3, " "=2, "Single" = 1, "Joint" = 1, " "=2, "P only" = 1, "P and Q" = 1, " " = 3))  %>%
#   kableExtra::add_header_above(c( " "=2, "P-dynamics"= 5, " "=2, "Q-dynamics"= 2, " "=2, "Sigma matrix estimation" = 2, " "=2, "Dom. Eco."=1), bold = T) %>%
# kableExtra::pack_rows("Unrestricted VAR", 1, 3 , label_row_css = "background-color: #666; color: #fff;")  %>%
# kableExtra::pack_rows("Restricted VAR (GVAR)", 4, 5, label_row_css = "background-color: #666; color: #fff;") %>%
# kableExtra::pack_rows("Restricted VAR (JLL)", 6, 8, label_row_css = "background-color: #666; color: #fff;") %>%
# kableExtra::column_spec(1, width = "10em") %>%
# kableExtra::column_spec(3:17, width = "4.5em") %>%
# kableExtra::footnote(general = "Risk factor dynamics under the \\(\\mathbb{P}\\)-measure may follow either an unrestricted (UR) or a restricted (R) specification. The set of restrictions present in the JLL-based and GVAR-based models are described in @JotikasthiraLeLundblad2015 and @CandelonMoura2024, respectively. The estimation of the \\(\\Sigma\\) matrix is done either exclusively with the other parameters of the \\(\\mathbb{P}\\)-dynamics (*P* column) or jointly under both \\(\\mathbb{P}\\)- and \\(\\mathbb{Q}\\)-parameters (*P and Q* column). *Dom. Eco.* relates to the presence of a dominant economy. The entries featuring *x* indicate that the referred characteristic is part of the model.",
#                      escape = FALSE)


## ----tab-ModFea-L, eval = knitr::is_latex_output()----------------------------
ModelLabels <- c("JPS original", "JPS global", "JPS multi", "GVAR single", "GVAR multi", 
                 "JLL original", "JLL No DomUnit", "JLL joint Sigma")

# Rows
Tab <- data.frame(matrix(nrow = length(ModelLabels), ncol = 0)) 
rownames(Tab) <- ModelLabels

# Empty columns
EmptyCol <- c("", "", "", "", "", "", "", "") 
Tab$EmptyCol0 <- EmptyCol
# P-dynamics + 2 empty spaces
Tab$PdynIndUnco <- c("x", "", "", "", "", "", "", "")
Tab$PdynIndCo <- c("", "", "", "", "", "", "", "")
Tab$PdynJointUnco <- c("", "x", "x", "", "", "", "", "")
Tab$PdynJointJLL <- c("", "", "", "", "", "x", "x", "x")
Tab$PdynJointGVAR <- c("", "", "", "x", "x", "", "", "")
Tab$EmptyCol1 <- EmptyCol
# Q-dynamics + 2 empty spaces
Tab$QdynInd <- c("x", "x", "", "x", "", "", "", "")   
Tab$QdynJoint <- c("", "", "x", "", "x", "x", "x", "x") 
Tab$EmptyCol4 <- EmptyCol
# Sigma + 2 empty spaces
Tab$Ponly <-  c("", "", "", "", "", "x", "x", "")
Tab$PandQ <- c("x", "x", "x", "x", "x", "", "", "x")
Tab$EmptyCol2 <- EmptyCol
# Dominant Unit
Tab$DomUnit <- c("", "", "", "", "", "x", "", "x")

# Adjust column names
ColNames <- c("","", "", "", "JLL", "GVAR", "", "", "", "", "","", "", "")
colnames(Tab) <- ColNames

# Generate the table
  kableExtra::kbl(Tab, align = "c", format = "latex", booktabs = TRUE,
                caption = "Summary of model features", escape = FALSE) %>%
  kableExtra::row_spec(0, bold = TRUE) %>%
  kableExtra::add_header_above(c(" " = 2, "UR" = 1, "R" = 1, "UR" = 1, "R" = 2, " " = 1, " " = 1, 
                                 " " = 1, " " = 1, " " = 1, " " = 1, " " = 1, " " = 1)) %>%
  kableExtra::add_header_above(c(" " = 2, "Single" = 2, "Joint" = 3, " " = 1, "Single" = 1,
                               "Joint" = 1, " " = 1, "P" = 1, "P and Q" = 1, " " = 1)) %>%            kableExtra::add_header_above(c(" " = 2,"P-dynamics" = 5, " " = 1,"Q-dynamics" = 2,
                                 " " = 1,"Sigma estimation" = 2, " " = 1,"Dom. Eco." = 1), 
                                 bold = TRUE) %>% 
kableExtra::pack_rows("Unrestricted VAR", 1, 3) %>%
kableExtra::pack_rows("Restricted VAR (GVAR)", 4, 5) %>%
kableExtra::pack_rows("Restricted VAR (JLL)", 6, 8) %>%
kableExtra::kable_styling(font_size = 7, latex_options = "hold_position") 
knitr::asis_output("
\\vspace{-2.5em}
\\begin{center}
\\captionsetup{type=table}
\\caption*{\\footnotesize Note: Risk factor dynamics under the $\\mathbb{P}$-measure may follow either an unrestricted (UR) or a restricted (R) specification. The set of restrictions present in the JLL-based and GVAR-based models are described in \\cite{JotikasthiraLeLundblad2015} and \\cite{CandelonMoura2024}, respectively. The estimation of the $\\Sigma$ matrix is done either exclusively with the other parameters of the $\\mathbb{P}$-dynamics (\\textit{P} column) or jointly under both $\\mathbb{P}$- and $\\mathbb{Q}$-parameters (\\textit{P and Q} column). \\textit{Dom. Eco.} relates to the presence of a dominant economy. The entries featuring \\textit{x} indicate that the referred characteristic is part of the model.}
\\end{center}
") 


## ----echo=TRUE----------------------------------------------------------------
LoadData("CM_2024")


## ----echo=TRUE----------------------------------------------------------------
ModelType <- "JPS original"
Economies <- c("Brazil", "Mexico", "Uruguay")
GlobalVar <- c("Gl_Eco_Act", "Gl_Inflation")
DomVar <- c("Eco_Act", "Inflation")
N <- 3
t0 <- "01-07-2005"
tF <- "01-12-2019"
DataFreq <- "Monthly"
StatQ <- FALSE
Folder2Save <- NULL
OutputLabel <- "Model_demo"


## ----echo=TRUE----------------------------------------------------------------
VARXtype <- "unconstrained"


## ----echo=TRUE----------------------------------------------------------------
data('TradeFlows')
W_type <- "Sample Mean"
t_First_Wgvar <- "2000"
t_Last_Wgvar <- "2015"
DataConnectedness <- TradeFlows 


## ----echo=TRUE----------------------------------------------------------------
GVARlist <- list(VARXtype = "unconstrained", W_type = "Sample Mean", 
                 t_First_Wgvar = "2000", t_Last_Wgvar = "2015", 
                 DataConnectedness = TradeFlows) 


## ----echo=TRUE----------------------------------------------------------------
# Example for "JLL original" and "JLL joint Sigma" models
JLLlist <- list(DomUnit =  "China")

# For "JLL No DomUnit" model
JLLlist <- list(DomUnit =  "None")


## ----echo = TRUE--------------------------------------------------------------
BRWlist <- within(list(Cent_Measure = "Mean", gamma = 0.2, N_iter = 500, B = 50, 
                       checkBRW = TRUE, B_check = 1000, Eigen_rest = 1), 
                       N_burn <- round(N_iter * 0.15))


## ----echo = TRUE--------------------------------------------------------------
DesiredGraphs <- c("Fit", "GIRF", "GFEVD", "TermPremia")


## ----echo = TRUE--------------------------------------------------------------
WishGraphRiskFac <- FALSE
WishGraphYields <- TRUE
WishOrthoJLLgraphs <- FALSE


## ----echo = TRUE--------------------------------------------------------------
Bootlist <- list(methodBS = 'block', BlockLength = 4, ndraws =  1000, pctg   =  95)


## ----echo = TRUE--------------------------------------------------------------
ForecastList <- list(ForHoriz = 12, t0Sample = 1, t0Forecast = 70, ForType = "Rolling")


## ----echo = TRUE--------------------------------------------------------------
data('Yields')
w <- pca_weights_one_country(Yields, Economy = "Uruguay")


## ----pca-H, fig.height = 5, fig.cap="Yield loadings on the spanned factors. Example using bond yield data for Uruguay. Graph generated using the ggplot2 package [@ggplot22016].", include=knitr::is_html_output(), eval=knitr::is_html_output()----
# 
# LabSpaFac <- c("Level", "Slope", "Curvature")
# N <- length(LabSpaFac)
# 
# mat <- c(0.25, 0.5, 1, 3, 5, 10)
# 
# w_pca <- data.frame(t(w[1:N,]))
# colnames(w_pca) <- LabSpaFac
# w_pca$mat <- mat
# 
# # Prepare plots
# colors <- c("Level" = "#0072B2", "Slope" = "#009E73", "Curvature" = "#D55E00")
# 
# g <- ggplot2::ggplot(data = w_pca, ggplot2::aes(x=  mat)) +
#     ggplot2::geom_line(ggplot2::aes(y = Level, color = "Level"), size = 0.7) +
#     ggplot2::geom_line(ggplot2::aes(y = Slope, color = "Slope"), size = 0.7) +
#     ggplot2::geom_line(ggplot2::aes(y = Curvature, color = "Curvature"),  size = 0.7) +
#       ggplot2::labs(color = "Legend") + ggplot2::scale_color_manual(values = colors) + ggplot2::theme_classic() +
#     ggplot2::theme(legend.position="top", legend.title=ggplot2::element_blank(), legend.text= ggplot2::element_text(size=8) ) +
#    ggplot2::xlab("Maturity (Years)") + ggplot2:: scale_y_continuous(name="Weights") + ggplot2::geom_hline(yintercept=0)
# 
# print(g)


## ----pca-L, fig.height = 2.8, fig.width = 5, fig.cap="Yield loadings on the spanned factors. Example using bond yield data for Uruguay. Graph was generated using the ggplot2 package \\citep{ggplot22016}.", include=knitr::is_latex_output(), eval=knitr::is_latex_output()----

LabSpaFac <- c("Level", "Slope", "Curvature")
N <- length(LabSpaFac)

mat <- c(0.25, 0.5, 1, 3, 5, 10) 

w_pca <- data.frame(t(w[1:N,]))
colnames(w_pca) <- LabSpaFac
w_pca$mat <- mat

# Prepare plots
colors <- c("Level" = "#0072B2", "Slope" = "#009E73", "Curvature" = "#D55E00")

    ggplot2::ggplot(data = w_pca, ggplot2::aes(x=  mat)) +
    ggplot2::geom_line(ggplot2::aes(y = Level, color = "Level"), size = 0.7) +
    ggplot2::geom_line(ggplot2::aes(y = Slope, color = "Slope"), size = 0.7) +
    ggplot2::geom_line(ggplot2::aes(y = Curvature, color = "Curvature"),  size = 0.7) +
      ggplot2::labs(color = "Legend") + ggplot2::scale_color_manual(values = colors) + ggplot2::theme_classic() +
    ggplot2::theme(legend.position="top", legend.title=ggplot2::element_blank(), legend.text= ggplot2::element_text(size=8) ) +
   ggplot2::xlab("Maturity (Years)") + ggplot2:: scale_y_continuous(name="Weights") + ggplot2::geom_hline(yintercept=0)  


## ----echo = TRUE--------------------------------------------------------------
data('Yields')
Economies <- c("China", "Brazil", "Mexico", "Uruguay")
N <- 2
SpaFact <- Spanned_Factors(Yields, Economies, N)


## ----echo = TRUE--------------------------------------------------------------
# Example 1: "JPS global" and "JPS multi" models
data("RiskFacFull")
PdynPara <- VAR(RiskFacFull, VARtype = "unconstrained")

# Example 2: "JPS original" model for China 
FactorsChina <- RiskFacFull[1:7, ]
PdynPara <- VAR(FactorsChina, VARtype = "unconstrained")


## ----echo = TRUE--------------------------------------------------------------
data("GVARFactors")


## ----echo = TRUE--------------------------------------------------------------
data('GVARFactors')
GVARinputs <- list(Economies = Economies, GVARFactors = GVARFactors, 
                   VARXtype ="constrained: Inflation")


## -----------------------------------------------------------------------------
data("TradeFlows")
t_First <- "2006"
t_Last <- "2019"
Economies <- c("China", "Brazil", "Mexico", "Uruguay")
type <- "Sample Mean"
W_gvar <- Transition_Matrix(t_First, t_Last, Economies, type, TradeFlows)

round(W_gvar, digits= 4)


## ----echo = TRUE--------------------------------------------------------------
data("GVARFactors")
GVARinputs <- list(Economies = Economies, GVARFactors = GVARFactors,  
                   VARXtype = "unconstrained", Wgvar = W_gvar)
N <- 3
GVARpara <- GVAR(GVARinputs, N, CheckInputs = TRUE)


## ----eval=FALSE, echo=TRUE----------------------------------------------------
# # First set the JLLinputs
# ModelType <- "JLL original"
# JLLinputs <- list(Economies = Economies, DomUnit = "China", WishSigmas = TRUE,
#                   SigmaNonOrtho = NULL, JLLModelType = ModelType)
# 
# # Then, estimate the desired the P-dynamics from the desired JLL model
# data("RiskFacFull")
# N <- 3
# JLLpara <- JLL(RiskFacFull, N, JLLinputs, CheckInputs = TRUE)


## ----FullImpl, cache=TRUE, echo = TRUE----------------------------------------
library(MultiATSM)
# 1) USER INPUTS
# A) Load database data
LoadData("CM_2024")

# B) GENERAL model inputs
ModelType <- "JPS original" 
Economies <- c("China", "Brazil") 
GlobalVar <- c("Gl_Eco_Act") 
DomVar <- c("Eco_Act") 
N <- 2  
t0_sample <- "01-05-2005" 
tF_sample <- "01-12-2019" 
OutputLabel <- "Test" 
DataFreq <-"Monthly"
Folder2Save <- NULL
StatQ <- FALSE 

# B.1) SPECIFIC model inputs
# GVAR-based models 
GVARlist <- list( VARXtype = "unconstrained", W_type = "Sample Mean", t_First_Wgvar = "2005",
                  t_Last_Wgvar = "2019", DataConnectedness = TradeFlows ) 

# JLL-based models 
JLLlist <- list(DomUnit =  "China")

# BRW inputs  
WishBC <- FALSE 
BRWlist <- within(list(Cent_Measure = "Mean", gamma = 0.05, N_iter = 250, B = 50, checkBRW = TRUE,
                       B_check = 1000, Eigen_rest = 1),  N_burn <- round(N_iter * 0.15))

# C) Decide on Settings for numerical outputs
WishFPremia <- TRUE 
FPmatLim <- c(60,120) 
                      
Horiz <- 30
DesiredGraphs <- c() 
WishGraphRiskFac <- FALSE
WishGraphYields <- FALSE
WishOrthoJLLgraphs <- FALSE

# D) Bootstrap settings
WishBootstrap <- TRUE 
BootList <- list(methodBS = 'bs', BlockLength = 4, ndraws = 5, pctg =  95)

# E) Out-of-sample forecast
WishForecast <- TRUE 
ForecastList <- list(ForHoriz = 12,  t0Sample = 1, t0Forecast = 162, ForType = "Rolling")

##########################################################################################
# NO NEED TO MAKE CHANGES FROM HERE:
# The sections below automatically process the inputs provided above, run the model 
# estimation, generate the numerical and graphical outputs, and save results.

# 2) Minor preliminary work: get the sets of factor labels
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)

# 3) Prepare the inputs of the likelihood function
ATSMInputs <- InputsForOpt(t0_sample, tF_sample, ModelType, Yields, GlobalMacro, 
                           DomMacro, FactorLabels, Economies, DataFreq, GVARlist, 
                           JLLlist, WishBC, BRWlist)

# 4) Optimization of the ATSM (Point Estimates)
ModelParaList <- Optimization(ATSMInputs, StatQ, DataFreq, FactorLabels, Economies, ModelType)

# 5) Numerical and graphical outputs
# a) Prepare list of inputs for graphs and numerical outputs
InputsForOutputs <- InputsForOutputs(ModelType, Horiz, DesiredGraphs, OutputLabel, StatQ, 
                                     DataFreq, WishGraphYields, WishGraphRiskFac, 
                                     WishOrthoJLLgraphs, WishFPremia, 
                                     FPmatLim, WishBootstrap, BootList, 
                                     WishForecast, ForecastList)
                                     
# b) Fit, IRF, FEVD, GIRF, GFEVD, and Term Premia
NumericalOutputs <- NumOutputs(ModelType, ModelParaList, InputsForOutputs, 
                               FactorLabels, Economies, Folder2Save)

# c) Confidence intervals (bootstrap analysis)
BootstrapAnalysis <- Bootstrap(ModelType, ModelParaList, NumericalOutputs, Economies, 
                               InputsForOutputs, FactorLabels, JLLlist, GVARlist, 
                               WishBC, BRWlist, Folder2Save)

# 6) Out-of-sample forecasting
Forecasts <- ForecastYields(ModelType, ModelParaList, InputsForOutputs, FactorLabels, 
                            Economies, JLLlist, GVARlist, WishBC, BRWlist, 
                            Folder2Save)


## ----FitYields, out.width="100%", fig.width = 6, fig.height = 4.5, fig.cap = if (knitr::is_html_output()) { knitr::asis_output("Chinese bond yield maturities with model fit comparisons. *Model-fit* reflects estimation using only risk-neutral ($\\mathbb{Q}$) dynamics parameters, while *Model-Implied* incorporates both physical ($\\mathbb{P}$) and risk-neutral ($\\mathbb{Q}$) dynamics. The $x$-axes represent time in months and the $y$-axis is in natural units.")} else{  knitr::asis_output("Chinese bond yield maturities with model fit comparisons. \\emph{Model-fit} reflects estimation using only risk-neutral ($\\mathbb{Q}$) dynamics parameters, while \\emph{Model-implied} incorporates both physical ($\\mathbb{P}$) and risk-neutral ($\\mathbb{Q}$) dynamics. The $x$-axes represent time in months and the $y$-axis is in natural units.")}----
FitYields <- autoplot(NumericalOutputs, type = "Fit")
FitYields$China


## ----IRF, out.width="100%", fig.width = 6, fig.height = 4.5, fig.cap = "IRFs from the Brazilian bond yields to global economic activity. Size of the shock is one-standard deviation. The black lines are the point estimates. Gray dashed lines are the bounds of the 95% confidence intervals and the green lines correspond to the median of these intervals. The $x$-axes are expressed in months and the $y$-axis is in natural units."----
IRFs_Graphs <- autoplot(BootstrapAnalysis, NumericalOutputs, type = "IRF_Yields_Boot")
IRFs_Graphs$Brazil$Gl_Eco_Act


## ----FEVD, out.width="100%", fig.width = 6, fig.height = 4.5, fig.cap = "FEVD from the Brazilian bond yield with maturity 60 months. The $x$-axis represents the forecast horizon in months and the $y$-axis is in natural units."----
FEVDs_Graphs <- autoplot(NumericalOutputs, type = "FEVD_Yields") 
FEVDs_Graphs$Brazil$Y60M_Brazil


## ----TermPremia, out.width="100%", fig.width = 6, fig.height = 4.5, fig.cap = "Chinese sovereign yield curve decomposition showing (i) expected future short rates and (ii) term premia components. The $x$-axis represents time in months and the $y$-axis is expressed in percentage points."----
TP_Graphs <- autoplot(NumericalOutputs, type = "TermPremia") 
TP_Graphs$China


## ----echo=TRUE----------------------------------------------------------------
MacroData  <- Load_Excel_Data(system.file("extdata", "MacroData.xlsx", 
                                          package = "MultiATSM"))
YieldsData <- Load_Excel_Data(system.file("extdata", "YieldsData.xlsx", 
                                          package = "MultiATSM"))


## ----echo=TRUE----------------------------------------------------------------
ModelType <- "JPS original"
Initial_Date <- "2006-09-01"
Final_Date <- "2019-01-01"
DataFrequency <- "Monthly"
GlobalVar <- c("GBC", "VIX")
DomVar <- c("Eco_Act", "Inflation", "Com_Prices", "Exc_Rates")
N <- 3
Economies <- c("China", "Mexico", "Uruguay", "Brazil", "Russia")


## ----echo=TRUE----------------------------------------------------------------
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)
RiskFactorsSet <- DataForEstimation(Initial_Date, Final_Date, Economies, N, FactorLabels,
                                    ModelType, DataFrequency, MacroData, YieldsData)


## ----echo=TRUE----------------------------------------------------------------
data("TradeFlows")
t_First <- "2006"
t_Last <- "2019"
Economies <- c("China", "Brazil", "Mexico", "Uruguay")
type <- "Sample Mean"
W_gvar <- Transition_Matrix(t_First, t_Last, Economies, type, TradeFlows)


## ----echo=TRUE----------------------------------------------------------------
    WishFPremia <- TRUE  
    FPmatLim <- c(60, 120)


## ----echo=TRUE----------------------------------------------------------------
# 1) INPUTS
# A) Load database data
LoadData("BR_2017")

# B) GENERAL model inputs
ModelType <- "JPS original"

Economies <- c("US") 
GlobalVar <- c() 
DomVar <- c("GRO", "INF")
N <- 3 
t0_sample <- "January-1985"
tF_sample <- "December-2007"
DataFreq <- "Monthly" 
StatQ <- FALSE 

# 2) Minor preliminary work
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType) 
Yields <- t(BR_jps_out$Y)
DomesticMacroVar <- t(BR_jps_out$M.o)
GlobalMacroVar <- c()

# 3) Prepare the inputs of the likelihood function
ATSMInputs <- InputsForOpt(t0_sample, tF_sample, ModelType, Yields, GlobalMacroVar, 
                           DomesticMacroVar, FactorLabels, Economies, DataFreq)

# 4) Optimization of the model
ModelPara <- Optimization(ATSMInputs, StatQ, DataFreq, FactorLabels, Economies, ModelType)


## ----QdynTab-H, eval = knitr::is_html_output(), layout = "l-body-outset"------
# options(scipen = 100)
# options(scipen = 100)
# 
# RowsQ <- c("$r_0$", "$\\lambda_1$", "$\\lambda_2$", "$\\lambda_3$")
# TableQ <- data.frame(matrix(NA, ncol = 0, nrow = length(RowsQ)))
# row.names(TableQ) <- RowsQ
# 
# PackageQ <- c(
#   ModelPara$`JPS original`$US$ModEst$Q$r0,
#   diag(ModelPara$`JPS original`$US$ModEst$Q$K1XQ)
# )
# BRq <- c(
#   BR_jps_out$est.llk$rho0.cP,
#   diag(BR_jps_out$est.llk$KQ.XX)
# )
# 
# TableQ$MultiATSM <- PackageQ
# TableQ$'BR (2017)' <- BRq
# 
# # Function for consistent width and right alignment in HTML
# format_html_num <- function(x, digits = 4) {
#   fmt <- formatC(x, format = "f", digits = digits)
#   fmt <- gsub("-", "−", fmt, fixed = TRUE)  # replace hyphen with Unicode minus
#   # wrap in right-aligned span to preserve your table's theme
#   paste0('<span style="display:inline-block; width:5em; text-align:right;">', fmt, '</span>')
# }
# 
# TableQ_fmt <- TableQ
# TableQ_fmt[] <- lapply(TableQ_fmt, function(col) {
#   if (is.numeric(col)) format_html_num(col) else col
# })
# 
# library(kableExtra)
# library(magrittr)
# 
# kbl(TableQ_fmt, align = "c", caption = "$Q$-dynamics parameters", escape = FALSE) %>%
#   kable_classic("striped", full_width = FALSE) %>%
#   row_spec(0, font_size = 14) %>%
#   footnote(
#     general = "λ's are the eigenvalues from the risk-neutral feedback matrix and r₀ is the long-run mean of the short rate under Q."
#   )


## ----QdynTab-L, eval = knitr::is_latex_output()-------------------------------
options(scipen = 100) # eliminate scientific notation

RowsQ <- c("$r_0$", "$\\lambda_1$", "$\\lambda_2$", "$\\lambda_3$")
TableQ <- data.frame(matrix(NA, ncol = 0, nrow = length(RowsQ)))
row.names(TableQ) <- RowsQ

PackageQ <- c(ModelPara$`JPS original`$US$ModEst$Q$r0, diag(ModelPara$`JPS original`$US$ModEst$Q$K1XQ))
BRq <- c(BR_jps_out$est.llk$rho0.cP, diag(BR_jps_out$est.llk$KQ.XX))
TableQ$MultiATSM <- PackageQ
TableQ$'BR (2017)' <- BRq

TableQ <- round(TableQ, digits = 4)

# Ensure that numbers in the table are actual numerical values. This is necessary to ensure that negative signs show up as dashes rather than hyphens.   
TableQ <- as.data.frame(TableQ)  
TableQ[] <- lapply(TableQ, function(col) {
  if (all(suppressWarnings(!is.na(as.numeric(col))))) {
    paste0("$", col, "$")
  } else {
    col
  }
})


format_latex_num <- function(x, digits = 4) {
  # Round and create a fixed-width string
  fmt <- formatC(x, format = "f", digits = digits, width = digits + 3)
  
  # Replace normal space padding with phantom zeros for alignment in LaTeX
  fmt <- gsub(" ", "\\\\phantom{0}", fmt)
  
  # Replace minus sign with LaTeX proper math minus
  fmt <- gsub("-", "\\\\text{-}", fmt)
  
  paste0("$", fmt, "$")
}

# Apply formatting only to numeric columns
TableQ_fmt <- TableQ
TableQ_fmt[] <- lapply(TableQ_fmt, function(col) {
  if (is.numeric(col)) format_latex_num(col) else col
})

library(kableExtra)

kable(
  TableQ_fmt,
  format = "latex",
  booktabs = TRUE,
  escape = FALSE,
  align = "r",
  caption = "$Q$-dynamics parameters"
) %>%
  kable_styling(font_size = 7, latex_options = "hold_position")
knitr::asis_output("
\\vspace{-2.0em}
\\begin{center}
\\footnotesize Note: $\\lambda$'s are the eigenvalues from the risk-neutral feedback matrix and $r_0$ is the long-run mean of the short rate under $\\mathbb{Q}$.
\\end{center}
")


## ----PdynTab-H, eval = knitr::is_html_output(), layout = "l-body-outset"------
# 
# RowsP <- c("PC1", "PC2", "PC3", "GRO", "INF")
# ColP <- c(" ", RowsP)
# 
# # 1) K0Z and K1Z
# # Bauer and Rudebusch coefficients
# TablePbr <- data.frame(matrix(NA, ncol = length(ColP), nrow = length(RowsP)))
# row.names(TablePbr) <- RowsP
# colnames(TablePbr) <- ColP
# 
# TablePbr[[ColP[1]]] <- BR_jps_out$est.llk$KP.0Z
# for (j in seq_along(RowsP)) {
#   TablePbr[[RowsP[j]]] <- BR_jps_out$est.llk$KP.ZZ[, j]
# }
# 
# TablePbr <- round(TablePbr, digits = 4)
# 
# # MultiATSM coefficients
# TablePMultiATSM <- data.frame(matrix(NA, ncol = length(ColP), nrow = length(RowsP)))
# row.names(TablePMultiATSM) <- RowsP
# colnames(TablePMultiATSM) <- ColP
# 
# PP <- BR_jps_out$W[1:N, ] %*% Yields
# ZZ <- rbind(PP, DomesticMacroVar)
# Pdyncoef <- VAR(ZZ, "unconstrained")
# 
# TablePMultiATSM[[ColP[1]]] <- Pdyncoef$K0Z
# for (j in seq_along(RowsP)) {
#   TablePMultiATSM[[RowsP[j]]] <- Pdyncoef$K1Z[, j]
# }
# 
# TablePMultiATSM <- round(TablePMultiATSM, digits = 4)
# 
# # Combine both tables
# TableP <- rbind(TablePbr, TablePMultiATSM)
# row.names(TableP) <- c(RowsP, paste0(RowsP, " "))
# 
# # ---- Formatting for HTML ----
# # Same right-aligned CSS approach as in Q-table
# format_html_num <- function(x, digits = 4) {
#   fmt <- formatC(x, format = "f", digits = digits)
#   fmt <- gsub("-", "−", fmt, fixed = TRUE)  # Unicode minus
#   paste0('<span style="display:inline-block; width:5em; text-align:right;">', fmt, '</span>')
# }
# 
# TableP_fmt <- TableP
# TableP_fmt[] <- lapply(TableP_fmt, function(col) {
#   if (is.numeric(col)) format_html_num(col) else col
# })
# 
# library(kableExtra)
# library(magrittr)
# 
# kbl(TableP_fmt, align = "c", caption = "$P$-dynamics parameters", escape = FALSE) %>%
#   kable_classic("striped", full_width = FALSE) %>%
#   row_spec(0, font_size = 14) %>%
#   add_header_above(c(" " = 1, "K0Z" = 1, "K1Z" = 5), bold = TRUE) %>%
#   pack_rows("BR (2017)", 1, 5) %>%
#   pack_rows("MultiATSM", 6, 10) %>%
#   footnote(
#     general = "$K0Z$ is the intercept and $K1Z$ is the feedback matrix from the $P$-dynamics."
#   )
# 


## ----PdynTab-L, eval = knitr::is_latex_output()-------------------------------

RowsP <- c("PC1", "PC2", "PC3", "GRO", "INF")
ColP <- c(" ", RowsP)

# --- 1) K0Z and K1Z : Bauer and Rudebusch coefficients ---
TablePbr <- data.frame(matrix(NA, ncol = length(ColP), nrow = length(RowsP)))
row.names(TablePbr) <- RowsP
colnames(TablePbr) <- ColP

TablePbr[[ColP[1]]] <- BR_jps_out$est.llk$KP.0Z
for (j in seq_along(RowsP)) {
  TablePbr[[RowsP[j]]] <- BR_jps_out$est.llk$KP.ZZ[, j]
}
TablePbr <- round(TablePbr, digits = 4)

# --- 2) MultiATSM coefficients ---
TablePMultiATSM <- data.frame(matrix(NA, ncol = length(ColP), nrow = length(RowsP)))
row.names(TablePMultiATSM) <- RowsP
colnames(TablePMultiATSM) <- ColP

PP <- BR_jps_out$W[1:N, ] %*% Yields
ZZ <- rbind(PP, DomesticMacroVar)
Pdyncoef <- VAR(ZZ, "unconstrained")

TablePMultiATSM[[ColP[1]]] <- Pdyncoef$K0Z
for (j in seq_along(RowsP)) {
  TablePMultiATSM[[RowsP[j]]] <- Pdyncoef$K1Z[, j]
}
TablePMultiATSM <- round(TablePMultiATSM, digits = 4)

# --- 3) Combine and label ---
TableP <- rbind(TablePbr, TablePMultiATSM)
row.names(TableP) <- c(RowsP, paste0(RowsP, " ")) # avoid duplicate names

# --- 4) Format numeric cells for LaTeX alignment ---
format_latex_num <- function(x, digits = 4) {
  fmt <- formatC(x, format = "f", digits = digits, width = digits + 4)
  fmt <- gsub(" ", "\\\\phantom{0}", fmt)      # pad spaces with phantom zeros
  fmt <- gsub("-", "\\\\text{-}", fmt)         # proper minus sign
  paste0("$", fmt, "$")
}

TableP_fmt <- TableP
TableP_fmt[] <- lapply(TableP_fmt, function(col) {
  if (is.numeric(col)) format_latex_num(col) else col
})

library(kableExtra)
library(magrittr)

kable(TableP_fmt, align = "c", format = "latex", booktabs = TRUE, escape = FALSE,
      caption = "$P$-dynamics parameters") %>%
  kable_styling(latex_options = "hold_position", font_size = 7) %>%
  add_header_above(c(" " = 1, "K0Z" = 1, "K1Z" = 5), bold = TRUE) %>%
  pack_rows("BR (2017)", 1, 5) %>%
  pack_rows("MultiATSM", 6, 10) %>%
  footnote(
    general = "$K0Z$ is the intercept and $K1Z$ is the feedback matrix from the $P$-dynamics.",
    escape = FALSE
  )


## ----eval=FALSE, echo=TRUE----------------------------------------------------
# # 1) INPUTS
# # A) Load database data
# LoadData("CM_2024")
# 
# # B) GENERAL model inputs
# ModelType <- "GVAR multi"
# Economies <- c("China", "Brazil", "Mexico", "Uruguay")
# GlobalVar <- c("Gl_Eco_Act", "Gl_Inflation")
# DomVar <- c("Eco_Act", "Inflation")
# N <- 3
# t0_sample <- "01-06-2004"
# tF_sample <- "01-01-2020"
# OutputLabel <- "CM_jfec"
# DataFreq <-"Monthly"
# StatQ <- FALSE
# 
# # B.1) SPECIFIC model inputs
# # GVAR-based models
# GVARlist <- list( VARXtype = "unconstrained", W_type = "Sample Mean", t_First_Wgvar = "2004",
#                   t_Last_Wgvar = "2019", DataConnectedness = TradeFlows )
# 
# # JLL-based models
# JLLlist <- list(DomUnit =  "China")
# 
# # BRW inputs
# WishBC <- TRUE
# BRWlist <- within(list(Cent_Measure = "Mean", gamma = 0.001, N_iter = 200, B = 50, checkBRW = TRUE,
#                        B_check = 1000, Eigen_rest = 1),  N_burn <- round(N_iter * 0.15))
# 
# # C) Decide on Settings for numerical outputs
# WishFPremia <- TRUE
# FPmatLim <- c(24,36)
# 
# Horiz <- 25
# DesiredGraphs <- c("GIRF", "GFEVD", "TermPremia")
# WishGraphRiskFac <- FALSE
# WishGraphYields <- TRUE
# WishOrthoJLLgraphs <- TRUE
# 
# # D) Bootstrap settings
# WishBootstrap <- FALSE
# BootList <- list(methodBS = 'bs', BlockLength = 4, ndraws = 1000, pctg =  95)
# 
# # E) Out-of-sample forecast
# WishForecast <- TRUE
# ForecastList <- list(ForHoriz = 12,  t0Sample = 1, t0Forecast = 100, ForType = "Rolling")
# 
# # 2) Minor preliminary work: get the sets of factor labels and  a vector of common maturities
# FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)
# 
# # 3) Prepare the inputs of the likelihood function
# ATSMInputs <- InputsForOpt(t0_sample, tF_sample, ModelType, Yields, GlobalMacro,
#                            DomMacro, FactorLabels, Economies, DataFreq,
#                            GVARlist, JLLlist, WishBC, BRWlist)
# 
# # 4) Optimization of the ATSM (Point Estimates)
# ModelParaList <- Optimization(ATSMInputs, StatQ, DataFreq, FactorLabels, Economies, ModelType)
# 
# # 5) Numerical and graphical outputs
# # a) Prepare list of inputs for graphs and numerical outputs
# InputsForOutputs <- InputsForOutputs(ModelType, Horiz, DesiredGraphs, OutputLabel, StatQ,
#                                      DataFreq, WishGraphYields, WishGraphRiskFac,
#                                      WishOrthoJLLgraphs, WishFPremia, FPmatLim,
#                                      WishBootstrap, BootList, WishForecast,
#                                      ForecastList)
# 
# # b) Fit, IRF, FEVD, GIRF, GFEVD, and Term Premia
# NumericalOutputs <- NumOutputs(ModelType, ModelParaList, InputsForOutputs,
#                                FactorLabels, Economies)
# 
# # c) Confidence intervals (bootstrap analysis)
# BootstrapAnalysis <- Bootstrap(ModelType, ModelParaList, NumericalOutputs, Economies,
#                                InputsForOutputs, FactorLabels, JLLlist, GVARlist,
#                                WishBC, BRWlist)
# 
# # 6) Out-of-sample forecasting
# Forecasts <- ForecastYields(ModelType, ModelParaList, InputsForOutputs, FactorLabels,
#                             Economies, JLLlist, GVARlist, WishBC, BRWlist)


## ----eval=FALSE, echo=TRUE----------------------------------------------------
# # 1) INPUTS
# # A) Load database data
# LoadData("CM_2023")
# 
# # B) GENERAL model inputs
# ModelType <- "GVAR multi"
# Economies <- c("Brazil", "India", "Russia", "Mexico")
# GlobalVar <- c("US_Output_growth", "China_Output_growth", "SP500")
# DomVar <- c("Inflation","Output_growth", "CDS", "COVID")
# N <- 2
# t0_sample <- "22-03-2020"
# tF_sample <- "26-09-2021"
# OutputLabel <- "CM_EM"
# DataFreq <-"Weekly"
# StatQ <- FALSE
# 
# # B.1) SPECIFIC model inputs
# # GVAR-based models
# GVARlist <- list(VARXtype = "constrained: COVID", W_type = "Sample Mean",
#                  t_First_Wgvar = "2015", t_Last_Wgvar = "2020",
#                  DataConnectedness = TradeFlows_covid)
# 
# # BRW inputs
# WishBC <- FALSE
# 
# # C) Decide on Settings for numerical outputs
# WishFPremia <- TRUE
# FPmatLim <- c(47,48)
# 
# Horiz <- 12
# DesiredGraphs <- c("GIRF", "GFEVD", "TermPremia")
# WishGraphRiskFac <- FALSE
# WishGraphYields <- TRUE
# WishOrthoJLLgraphs <- FALSE
# 
# # D) Bootstrap settings
# WishBootstrap <- TRUE
# BootList <- list(methodBS = 'bs', BlockLength = 4, ndraws = 100, pctg =  95)
# 
# # 2) Minor preliminary work: get the sets of factor labels and  a vector of common maturities
# FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)
# 
# # 3) Prepare the inputs of the likelihood function
# ATSMInputs <- InputsForOpt(t0_sample, tF_sample, ModelType, Yields_covid, GlobalMacro_covid,
#                            DomMacro_covid, FactorLabels, Economies, DataFreq, GVARlist)
# 
# # 4) Optimization of the ATSM (Point Estimates)
# ModelParaList <- Optimization(ATSMInputs, StatQ, DataFreq, FactorLabels, Economies, ModelType)
# 
# # 5) Numerical and graphical outputs
# # a) Prepare list of inputs for graphs and numerical outputs
# InputsForOutputs <- InputsForOutputs(ModelType, Horiz, DesiredGraphs, OutputLabel, StatQ,
#                                      DataFreq, WishGraphYields, WishGraphRiskFac,
#                                      WishOrthoJLLgraphs, WishFPremia, FPmatLim,
#                                      WishBootstrap, BootList)
# 
# # b) Fit, IRF, FEVD, GIRF, GFEVD, and Term Premia
# NumericalOutputs <- NumOutputs(ModelType, ModelParaList, InputsForOutputs, FactorLabels,
#                                Economies)
# 
# # c) Confidence intervals (bootstrap analysis)
# BootstrapAnalysis <- Bootstrap(ModelType, ModelParaList, NumericalOutputs, Economies,
#                                InputsForOutputs, FactorLabels,
#                                JLLlist = NULL, GVARlist)

