# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit AcceptReject.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE, cache = TRUE)
library(AcceptReject)
library(numDeriv)
library(ggplot2)
library(parallel)
library(bench)


## ----"fig-inspect-1", out.width="50%", fig.align='center', fig.cap = "Inspection of the probability density function of the random variable of interest with the base probability density function, with $c = 1$ (default) (a) and $c = 4.3$ (b).", eval = TRUE, echo = FALSE, fig.pos="H"----
#| fig-subcap:
#|  - "For $c = 1$ (default)."
#|  - "For $c = 4.3$."
#| layout-ncol: 2
library(AcceptReject)

# Considering c = 1 (default)
  inspect(
  f = dweibull,
  f_base = dunif,
  xlim = c(0, 5),
  args_f = list(shape = 2, scale = 1),
  args_f_base = list(min = 0, max = 5),
  c = 1
)

# Considering c = 4.3
  inspect(
  f = dweibull,
  f_base = dunif,
  xlim = c(0, 5),
  args_f = list(shape = 2, scale = 1),
  args_f_base = list(min = 0, max = 5),
  c = 4.3
)


## ----eval = FALSE, echo = TRUE------------------------------------------------
# # Install CRAN version
# install.packages("remotes")
# 
# # Installing the development version from GitHub
# # or install.packages("remotes")
# remotes::install_github("prdm0/AcceptReject", force = TRUE)
# 
# # Load the package
# library(AcceptReject)


## ----logo, out.width = "25%", fig.align = "center", fig.cap="Logo of the package.", eval=TRUE, echo = FALSE, fig.pos="H"----
knitr::include_graphics("figures/logo.png")


## ----echo = TRUE, eval = FALSE------------------------------------------------
# inspect(
#   f,
#   args_f,
#   f_base,
#   args_f_base,
#   xlim,
#   c = 1,
#   alpha = 0.4,
#   color_intersection = "#BB9FC9",
#   color_f = "#FE4F0E",
#   color_f_base = "#7BBDB3"
# )


## -----------------------------------------------------------------------------
#| eval: FALSE
#| echo: TRUE
# library(AcceptReject)
# 
# # Considering c = 1 (default)
# inspect(
#   f = dweibull,
#   f_base = dunif,
#   xlim = c(0, 5),
#   args_f = list(shape = 2, scale = 1),
#   args_f_base = list(min = 0, max = 5),
#   c = 1
# )


## ----eval = FALSE, echo = TRUE------------------------------------------------
# accept_reject(
#   n = 1L,
#   continuous = TRUE,
#   f = NULL,
#   args_f = NULL,
#   f_base = NULL,
#   random_base = NULL,
#   args_f_base = NULL,
#   xlim = NULL,
#   c = NULL,
#   parallel = FALSE,
#   cores = NULL,
#   warning = TRUE,
#   ...
# )


## ----eval = TRUE, echo = TRUE-------------------------------------------------
set.seed(0)

# Generate 100 observations from a random variable X with
# f_X(x) = 2x, 0 <= x <= 1.
x <- accept_reject(
  n = 100L,
  f = function(x) 2 * x,
  args_f = list(),
  xlim = c(0, 1),
  warning = FALSE
)
print(x[1L:8L])


## -----------------------------------------------------------------------------
#| echo: TRUE
# setting a seed for reproducibility
set.seed(0)
x <- accept_reject(
   n = 2000L,
   f = dbinom,
   continuous = FALSE,
   args_f = list(size = 5, prob = 0.5),
   xlim = c(0, 10)
)

# Printing the first 10 (default) observations
print(x)

# Printing the first 20 observations
print(x, n_min = 20L)

# Summary
summary(x)


## ----eval = FALSE, echo = TRUE------------------------------------------------
#| echo: TRUE
#| eval: FALSE
# ## S3 method for class 'accept_reject'
# plot(
#   x,
#   color_observed_density = "#BB9FC9",
#   color_true_density = "#FE4F0E",
#   color_bar = "#BB9FC9",
#   color_observable_point = "#7BBDB3",
#   color_real_point = "#FE4F0E",
#   alpha = 0.3,
#   hist = TRUE,
#   ...
# )


## ----"fig-plotfunc-1", fig.cap="Plotting the theoretical density function (a) and the probability mass function (b), with details of the respective parameters in the code.", echo = TRUE, out.width="50%", fig.align='center', fig.pos="H"----
#| fig-subcap:
#|  - "Weibull with $n = 2000$ observations."
#|  - "Binomial with $n = 1000$ observations."
#| layout-ncol: 2
library(AcceptReject)

# Generating and plotting the theoretical density with the
# observed density.

# setting a seed for reproducibility
set.seed(0)

# Continuous case
accept_reject(
  n = 2000L,
  continuous = TRUE,
  f = dweibull,
  args_f = list(shape = 2.1, scale = 2.2),
  xlim = c(0, 10)
) |>
  plot(
    hist = FALSE,
    color_true_density = "#2B8b99",
    color_observed_density = "#F4DDB3",
    alpha = 0.6
  ) # Changing some arguments in plot()

# Discrete case
accept_reject(
  n = 1000L,
  f = dbinom,
  continuous = FALSE,
  args_f = list(size = 5, prob = 0.5),
  xlim = c(0, 10)
) |> plot()


## ----"fig-poisson-1", echo = TRUE, fig.cap="Generating observations from a Poisson distribution using the acceptance-rejection method, with $n = 25$ (a) and $n = 2500$ (b), respectively.", fig.align='center', out.width="50%", fig.pos="H"----
#| fig-subcap:
#|  - "n = 25 observations."
#|  - "n = 2500 observations."
#| layout-ncol: 2
library(AcceptReject)
library(parallel)
library(cowplot) # install.packages("cowplot")

# Ensuring reproducibility in parallel computing
RNGkind("L'Ecuyer-CMRG")
set.seed(0)
mc.reset.stream()

# Simulation
simulation <- function(n, lambda = 0.7)
  accept_reject(
    n = n,
    f = dpois,
    continuous = FALSE, # discrete case
    args_f = list(lambda = lambda),
    xlim = c(0, 20),
    parallel = TRUE # Parallelizing the code in Unix-based systems
)

# Generating observations
# n = 25 observations
system.time({x <- simulation(25L)})
plot(x)

# n = 2500 observations
system.time({y <- simulation(2500L)})
plot(y)


## ----echo = TRUE, fig.cap="Generating observations from a continuous random variable with a Standard Normal distribution.", fig.align='center', out.width="50%", fig.pos="H"----
#| label: fig-normal
#| fig-cap: "Generating observations from a continuous random variable with a Standard Normal distribution, with $n = 50$ and $n = 500$ observations, respectively."
#| fig-subcap:
#|  - "n = 50 observations."
#|  - "n = 500 observations."
#| layout-ncol: 2

library(AcceptReject)
library(parallel)

# Ensuring reproducibility in parallel computing
RNGkind("L'Ecuyer-CMRG")
set.seed(0)
mc.reset.stream()

# Generating observations
accept_reject(
  n = 50L,
  f = dnorm,
  continuous = TRUE,
  args_f = list(mean = 0, sd = 1),
  xlim = c(-4, 4),
  parallel = TRUE
) |> plot()

accept_reject(
  n = 500L,
  f = dnorm,
  continuous = TRUE,
  args_f = list(mean = 0, sd = 1),
  xlim = c(-4, 4),
  parallel = TRUE
) |> plot()


## ----echo = TRUE--------------------------------------------------------------
#| label: modified_beta
#| echo: TRUE
#| eval: TRUE
#|
library(numDeriv)

pdf <- function(x, G, ...){
  numDeriv::grad(
    func = \(x) G(x, ...),
    x = x
  )
}

# Modified Beta Distributions
# Link: https://link.springer.com/article/10.1007/s13571-013-0077-0
generator <- function(x, G, a, b, beta, ...){
  g <- pdf(x = x, G = G, ...)
  numerator <- beta^a * g * G(x, ...)^(a - 1) * (1 - G(x, ...))^(b - 1)
  denominator <- beta(a, b) * (1 - (1 - beta) * G(x, ...))^(a + b)
  numerator/denominator
}

# Probability density function - Modified Beta Weibull
pdf_mbw <- function(x, a, b, beta, shape, scale)
  generator(
    x = x,
    G = pweibull,
    a = a,
    b = b,
    beta = beta,
    shape = shape,
    scale = scale
  )

# Checking the value of the integral
integrate(
  f = \(x) pdf_mbw(x, 1, 1, 1, 1, 1),
  lower = 0,
  upper = Inf
)


## ----echo = TRUE, out.width="50%", fig.align='center', fig.pos="H"------------
#| label: fig-nadarajah
#| fig.cap: Inspecting the Weibull distribution with shape = 2, scale = 1.2, with the support xlim = c(0, 4) and c = 1 (default) (a) and c = 2.2 (b), respectively.
#| fig.subcap:
#|  - "For c = 1."
#|  - "For c = 2.2."
#| layout-ncol: 2

library(AcceptReject)

# True parameters
a <- 10.5
b <- 4.2
beta <- 5.9
shape <- 1.5
scale <- 1.7

# c = 1 (default)
inspect(
  f = pdf_mbw,
  f_base = dweibull,
  xlim = c(0, 4),
  args_f = list(
    a = a,
    b = b,
    beta = beta,
    shape = shape,
    scale = scale
  ),
  args_f_base = list(shape = 2, scale = 1.2),
  c = 1
)

# c = 2.2
inspect(
  f = pdf_mbw,
  f_base = dweibull,
  xlim = c(0, 4),
  args_f = list(
    a = a,
    b = b,
    beta = beta,
    shape = shape,
    scale = scale
  ),
  args_f_base = list(shape = 2, scale = 1.2),
  c = 2.2
)


## ----out.width="50%", fig.align='center', echo = FALSE, fig.pos="H"-----------
#| label: fig-benchmarking
#| fig.cap: Benchmarking for different sample sizes, considering the Weibull distribution and the uniform distribution as the base density, with Weibull distribution and Uniform distribution (default), respectively.
#| fig-subcap:
#|  - "Weibull distribution."
#|  - "Uniform distribution (default)."
#| layout-ncol: 2

library(AcceptReject)
library(numDeriv) # install.packages("numDeriv")
library(bench) # install.packages("bench")
library(ggplot2) # install.packages("ggplot2")
library(parallel)

simulation <- function(n, parallel = TRUE, base = TRUE) {
  # True parameters
  a <- 10.5
  b <- 4.2
  beta <- 5.9
  shape <- 1.5
  scale <- 1.7
  c <- 2.2

  # Generate data with the true parameters using
  # the AcceptReject package.
  if (base) {
    # Using the Weibull distribution as the base distribution
    accept_reject(
      n = n,
      f = pdf_mbw,
      args_f = list(
        a = a,
        b = b,
        beta = beta,
        shape = shape,
        scale = scale
      ),
      f_base = dweibull,
      args_f_base = list(shape = 2, scale = 1.2),
      random_base = rweibull,
      xlim = c(0, 4),
      c = c,
      parallel = parallel
    )
  } else {
    # Using the uniforme distribution as the base distribution
    accept_reject(
      n = n,
      f = pdf_mbw,
      args_f = list(
        a = a,
        b = b,
        beta = beta,
        shape = shape,
        scale = scale
      ),
      xlim = c(0, 4),
      parallel = parallel
    )
  }
}

benchmark <- function(n_values,
                      time_unit = 's',
                      base = TRUE) {
  # Initialize an empty data frame to store the results
  results_df <- data.frame()

  # Run benchmarks for each sample size and each type of code
  for (n in n_values) {
    for (parallel in c(TRUE, FALSE)) {
      results <- bench::mark(
        simulation(
          n = n,
          parallel = parallel,
          base = base
        ),
        time_unit = time_unit,
        memory = FALSE,
        check = FALSE,
        filter_gc = FALSE
      )

      # Convert results to data frame and add columns for the sample
      # size and type of code
      results_df_temp <- as.data.frame(results)
      results_df_temp$n <- n
      results_df_temp
      results_df_temp$Code <- ifelse(parallel, "Parallel", "Serial")

      # Append the results to the results data frame
      results_df <- rbind(results_df, results_df_temp)
    }
  }

  # Create a scatter plot of the median time vs the sample size,
  # colored by the type of code
  ggplot(results_df, aes(x = n, y = median, color = Code)) +
    geom_point() +
    scale_x_log10() +
    scale_y_log10() +
    labs(x = "Sample Size (n)", y = "Median Time (s)", color = "Code Type") +
    ggtitle("Benchmark Results") +
    ggplot2::theme(
      axis.title = ggplot2::element_text(face = "bold"),
      title = ggplot2::element_text(face = "bold"),
      legend.title = ggplot2::element_text(face = "bold"),
      plot.subtitle = ggplot2::element_text(face = "plain")
    )
}

# Sample sizes
n <- c(50,
       250,
       500,
       1e3,
       5e3,
       10e3,
       15e3,
       25e3,
       50e3,
       100e3,
       150e3,
       250e3,
       500e3,
       1e6)

# Ensuring reproducibility in parallel computing
RNGkind("L'Ecuyer-CMRG")
set.seed(0)
mc.reset.stream()

# Run the benchmark function for multiple sample sizes
n |> benchmark(n_values = _, base = TRUE)
n |> benchmark(n_values = _, base = FALSE)


## ----out.width="50%", fig.align='center', fig.pos='H'-------------------------
#| label: fig-bench
#| fig.cap: "Comparison between the AcceptReject and SimDesign package for different sample sizes, considering the generation of observations from a random variable with a Modified Beta Weibull distribution, serial processing with AcceptReject (a) and parallel processing with AcceptReject package (b), respectively."
#| fig-subcap:
#|  - "Weibull distribution."
#|  - "Uniform distribution (default)."
#| layout-ncol: 2
#| warning: false
#| echo: false

library(AcceptReject)
library(SimDesign)
library(numDeriv)
library(bench)
library(parallel)

simulation_1 <- function(n, parallel = TRUE, base = TRUE) {
  accept_reject(
    n = n,
    f = pdf_mbw,
    args_f = list(
      a = 10,
      b = 1,
      beta = 20.5,
      shape = 2,
      scale = 0.3
    ),
    xlim = c(0, 1),
    parallel = parallel
  )
}

simulation_2 <- function(n) {
  df = \(x) pdf_mbw(
    x = x,
    a = 10,
    b = 1,
    beta = 20.5,
    shape = 2,
    scale = 0.3
  )
  dg = \(x) dunif(x = x, min = 0, max = 1)
  rg = \(n) runif(n = n, min = 0, max = 1)

  # when df and dg both integrate to 1, acceptance probability = 1/M
  M <-
    rejectionSampling(df = df, dg = dg, rg = rg)
  rejectionSampling(n,
                    df = df,
                    dg = dg,
                    rg = rg,
                    M = M)
}

benchmark <- function(n_values, parallel = TRUE) {
  # Initialize an empty data frame to store the results
  results_df <- data.frame()

  # Run benchmarks for each sample size and each type of code
  filter_gc <- ifelse(parallel, FALSE, TRUE)
  for (n in n_values) {
    results <- bench::mark(
      AcceptReject = simulation_1(n = n, parallel = parallel),
      SimDesign = simulation_2(n = n),
      time_unit = 's',
      memory = FALSE,
      check = FALSE,
      filter_gc = filter_gc
    )

    # Convert results to data frame and add columns for the sample
    # size and type of code
    results_df_temp <- results
    results_df_temp$n <- n

    # Append the results to the results data frame
    results_df <- rbind(results_df, results_df_temp)
  }

  # Create a scatter plot of the median time vs the sample size,
  # colored by the type of code
  ggplot(results_df, aes(x = n, y = median, color = expression)) +
    geom_point() +
    scale_x_log10() +
    scale_y_log10() +
    labs(x = "Sample Size (n)", y = "Median Time (s)", color = "Packages") +
    ggtitle("Benchmark Results") +
    theme(
      axis.title = element_text(face = "bold"),
      title = element_text(face = "bold"),
      legend.title = element_text(face = "bold"),
      plot.subtitle = element_text(face = "plain")
    )
}

small_and_moderate_sample <- c(100,
                               150,
                               250,
                               500,
                               1e3,
                               1500,
                               2000,
                               2500,
                               3500,
                               4500,
                               5500,
                               7500,
                               10e3,
                               25e3)
big_sample <- c(50e3, 75e3, 100e3, 150e3, 250e3, 500e3, 750e3, 1e6)
# Ensuring reproducibility in parallel computing
RNGkind("L'Ecuyer-CMRG")
set.seed(0)
mc.reset.stream()

# Serial
benchmark(n_values = small_and_moderate_sample, parallel = FALSE)

# Parallel
benchmark(n_values = big_sample, parallel = TRUE)

